VERSION 5.00
Begin VB.Form frmMsgBoxEx 
   AutoRedraw      =   -1  'True
   Caption         =   "frmMsgBoxEx"
   ClientHeight    =   1575
   ClientLeft      =   60
   ClientTop       =   450
   ClientWidth     =   3015
   BeginProperty Font 
      Name            =   "MS Sans Serif"
      Size            =   9.75
      Charset         =   0
      Weight          =   400
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   LinkTopic       =   "Form2"
   ScaleHeight     =   105
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   201
   StartUpPosition =   3  'Windows-Standard
   Begin VB.PictureBox picOfficeBtn 
      Height          =   360
      Index           =   0
      Left            =   960
      ScaleHeight     =   300
      ScaleWidth      =   1080
      TabIndex        =   1
      Top             =   1080
      Width           =   1140
   End
   Begin VB.CommandButton cButton 
      Caption         =   "cButton"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   360
      Index           =   0
      Left            =   960
      TabIndex        =   0
      Top             =   600
      Width           =   1140
   End
End
Attribute VB_Name = "frmMsgBoxEx"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

   

' ================================================================= '
'
'     --------------
'     MsgBoxEx (GES)
'     --------------
'
' Autor:
' Guido Eisenbeis Software (GES), guidoeisenbeis@web.de, 2004-08-28
' ================================================================= '


' Deklarationen fr "Skin 'Office'" =============================== v

' Zu: "MouseIn - MouseOut prfen"
Private Type POINTAPI
  x As Long
  y As Long
End Type
'
Private Declare Function GetCursorPos Lib "user32" (lpPoint As POINTAPI) As Long
Private Declare Function WindowFromPoint Lib "user32" (ByVal xPoint As Long, ByVal yPoint As Long) As Long
Private Declare Function GetCapture Lib "user32" () As Long
Private Declare Function SetCapture Lib "user32" (ByVal hwnd As Long) As Long
Private Declare Function ReleaseCapture Lib "user32" () As Long

' Zu: DrawTextEx
Private Type RECT
    Left As Long
    Top As Long
    Right As Long
    Bottom As Long
End Type
'
Private Declare Function GetClientRect Lib "user32" (ByVal hwnd As Long, lpRect As RECT) As Long
'
Private Declare Function DrawTextEx Lib "user32" Alias "DrawTextExA" (ByVal hdc As Long, ByVal lpsz As String, ByVal n As Long, lpRect As RECT, ByVal un As Long, lpDrawTextParams As Any) As Long
Private Const DT_CENTER  As Long = &H1
Private Const DT_VCENTER  As Long = &H4
Private Const DT_SINGLELINE  As Long = &H20
Private Const DT_NOCLIP As Long = &H100

' Fokus-Rechteck zeichnen
Private Declare Function DrawFocusRect Lib "user32" (ByVal hdc As Long, lpRect As RECT) As Long
Private Declare Function InflateRect Lib "user32" (lpRect As RECT, ByVal x As Long, ByVal y As Long) As Long
Private Declare Function GetForegroundWindow Lib "user32" () As Long

Private DefBtnNo As Integer
Private MouseIsDown As Boolean
' ================================================================= ^


' Grund-Code (ohne "Skin") ======================================== v

' Funktionen zum ffnen von HTML-Help (.chm-Dateien)
Private Declare Function HtmlHelp Lib "hhctrl.ocx" Alias "HtmlHelpA" (ByVal hwndCaller As Long, ByVal pszFile As String, ByVal uCommand As Long, ByVal dwData As Long) As Long
Private Declare Function HtmlHelpTopic Lib "hhctrl.ocx" Alias "HtmlHelpA" (ByVal hwnd As Long, ByVal lpHelpFile As String, ByVal wCommand As Long, ByVal dwData As String) As Long
Private Const HH_DISPLAY_TOPIC = &H0

' Funktion zum ffnen von beliebigen Dateien
Private Declare Function ShellExecute Lib "shell32.dll" Alias "ShellExecuteA" (ByVal hwnd As Long, ByVal lpOperation As String, ByVal lpFile As String, ByVal lpParameters As String, ByVal lpDirectory As String, ByVal nShowCmd As Long) As Long

' Funktion zum Schlieen von Fenstern
Private Declare Function SendMessage Lib "user32" Alias "SendMessageA" (ByVal hwnd As Long, ByVal wMsg As Long, ByVal wParam As Long, lParam As Any) As Long
Private Const WM_CLOSE = &H10
Private HelpHWND As Long


Public MBExHelpFile As String ' Pfad zur Hilfe-Datei
Public MBExParams As String   ' zustzliche Parameter
Public MBExRetval As Integer  ' Rckgabe-Wert fr "MsgBoxEx"


Private Sub cButton_Click(Index As Integer)
   
   ' falls der Hilfe-Button geklickt wurde *
   If cButton(Index).Tag = "MBExHelpButton" Then
      ' Hier Befehle fr "Hilfe" einfgen
      Call ShowMBExHelp
   Else
      MBExRetval = Index
      Unload Me
   End If
End Sub
'
'  * Hinweis!
'  Die Tag-Eigenschaften der Form und
'  des Hilfe-Buttons knnen nicht benutzt
'  werden, da sie schon in Verwendung sind!

' Beispiel fr den Aufruf einer Hilfe-Datei
Private Sub ShowMBExHelp()

   On Error Resume Next ' Fehlerbehandlung aus
      
   If MBExHelpFile = "" Then Exit Sub
   If (LCase(Right$(MBExHelpFile, 4)) = ".chm") And (MBExParams <> "") Then
      ' Html-Hilfe mit einer bestimmten Seite ffnen
      HelpHWND = HtmlHelpTopic(0, MBExHelpFile, _
                  HH_DISPLAY_TOPIC, MBExParams)
   Else
      ' Html-Hilfe mit Startseite, oder beliebige Datei
      ' (.txt, .doc, .htm ...) mit oder ohne Parameter ffnen
      Call ShellExecute(Me.hwnd, "Open", _
         MBExHelpFile, MBExParams, "", 1)
   End If
      
   On Error GoTo 0 ' Fehlerbehandlung ein

End Sub

' Steurerung per Tastatur ermglichen
Private Sub Form_KeyDown(KeyCode As Integer, Shift As Integer)
   Dim B As CommandButton
   ' F1-Taste wurde gedrckt
   If KeyCode = vbKeyF1 Then
      KeyCode = 0
      ' Hilfe aufrufen, falls vorhanden
      For Each B In Me
         If B.Tag = "MBExHelpButton" Then
            B.SetFocus
            B = True
            Exit For
         End If
      Next B
   ' Escape-Taste wurde gedrckt
   ElseIf KeyCode = vbKeyEscape Then
      KeyCode = 0
      ' "frmMsgBoxEx" schlieen, falls erlaubt
      If Me.Tag <> "NoCloseButton" Then Unload Me
   End If
End Sub

Private Sub Form_Unload(Cancel As Integer)
   ' Wenn eine Hilfe-Datei mit einer bestimmten Seite und
   ' "HtmlHelp" geffnet wird, muss das Fenster der Hilfe
   ' geschlossen sein, bevor das Programm beendet wird.
   ' Ansonsten erfolgt eine Speicherzugriffsverletzung.
   If HelpHWND Then
      SendMessage HelpHWND, WM_CLOSE, 0&, 0&
      HelpHWND = 0
   End If
End Sub
' ================================================================= ^



' ================================================================= v
'                           "Skin 'Office'"                         v
' ================================================================= v

'Private Sub Form_Load()
'   ' ForeColor und BackColor knnen an folgenden
'   ' Stellen gendert werden:
'   ' 1) an frmMsgBoxEx selbst (zur Entwicklungszeit)
'   ' 2) hier im Form-Load
'   ' 3) an beliebiger Stelle des Projekts direkt
'   '    vor dem MsgBoxEx-Aufruf
'
'   ' Hinweis!
'   ' Abhngig von der Auflsung des Monitors kann bei
'   ' farbigem Hintergrund der Msg-Text unleserlich sein!
'
'   ' Beispiel:
'   Me.BackColor = vbBlue
'   Me.ForeColor = vbWhite
'End Sub

Private Sub Form_Activate()
   Dim x As Integer
   
   ' Grundeinstellungen fr PicBox "0"
   With picOfficeBtn(0)
      .Visible = False
      .AutoRedraw = True
      .Appearance = 0
      .BorderStyle = 0
      .BackColor = Me.BackColor
      .ForeColor = Me.ForeColor
      Set .Font = Me.Font
      .ScaleMode = vbPixels
   End With

   For x = 1 To cButton.UBound
      
      ' PicBoxes laden und einrichten
      Load picOfficeBtn(x)
      With picOfficeBtn(x)
         .Move cButton(x).Left, cButton(x).Top, _
               cButton(x).Width, cButton(x).Height
         .Visible = True
         If cButton(x).Tag = "ShowHelpButton" Then
            .Font = "Arial"
            .FontSize = 12
            .FontBold = True
         End If
      End With
      
      ' Caption zeichnen
      If cButton(x).Default Then
         DefBtnNo = x
         Call DrawPicButtonCaption(picOfficeBtn(x), True)
      Else
         Call DrawPicButtonCaption(picOfficeBtn(x), False)
      End If
      
      cButton(x).ZOrder 1      ' in den Hintergrund setzen
      picOfficeBtn(x).ZOrder 0 ' in den Vordergrund setzen
   Next x
End Sub

Private Sub cButton_GotFocus(Index As Integer)
   Call DrawPicButtonCaption(picOfficeBtn(Index), True)
End Sub

Private Sub cButton_LostFocus(Index As Integer)
   Call DrawPicButtonCaption(picOfficeBtn(Index), False)
End Sub

' Prozedur zum Setzen des Fokus ausschlielich auf die cButtons
Private Sub picOfficeBtn_GotFocus(Index As Integer)
   Dim x As Integer
   
   ' beim versetzen des Fokus mit der Tastatur wird nach dem
   ' letzten cButton der Fokus auf einen PicBox-Button gesetzt.
   ' Um das zu verhindern, wird der Fokus auf den entsprechenden
   ' cButton vor oder hinter dem aktuellen gesetzt.
   
   If Not MouseIsDown Then ' nicht ausfhren bei Mouse-Click
      If Index = 1 Then ' Fokus wird vorwrts versetzt
         x = DefBtnNo
      Else ' Fokus wird rckwrts versetzt
         ' falls der erste Button der Default-Button ist, ...
         If DefBtnNo = 1 Then
            x = cButton.Count ' ...zum letzten Button springen, ...
         Else
            x = DefBtnNo - 1 ' ... ansonsten auf den vornedran springen
         End If
      End If
      cButton(x).SetFocus ' alles klar, Fokus setzen
   End If
   
End Sub

Private Sub picOfficeBtn_MouseDown(Index As Integer, Button As Integer, Shift As Integer, x As Single, y As Single)
   MouseIsDown = True
End Sub

Private Sub picOfficeBtn_MouseUp(Index As Integer, Button As Integer, Shift As Integer, x As Single, y As Single)
   MouseIsDown = False
   cButton(Index).SetFocus
   Call SetPicBtnColors(picOfficeBtn(Index), _
                Me.BackColor, Me.ForeColor)
   
   ' Damit sowohl eine Hilfe-Datei aufgerufen, als
   ' auch das Formular entladen werden kann, mu
   ' dieser Befehl am Schlu stehen
   Call cButton_Click(Index)
End Sub

' beim berfahren des PicBox-Buttons mit der Maus
' die Farben ndern (Hover-Effekt)
Private Sub picOfficeBtn_MouseMove(Index As Integer, Button As Integer, Shift As Integer, x As Single, y As Single)
   ' nur wenn Fenster aktiv ist (dunkelblaue Titelleiste)
   If Me.hwnd = GetForegroundWindow Then
      Call MouseOverState(picOfficeBtn(Index))
   End If
End Sub

' Prozedur zum Zeichnen der Button-Caption
Private Sub DrawPicButtonCaption(ByVal PicBtn As PictureBox, _
                                 ByVal FocRect As Boolean)
   Dim sCapt As String
   Dim PicRc As RECT
   
   PicBtn.Cls ' Wichtig!
   sCapt = cButton(PicBtn.Index).Caption
   Call GetClientRect(PicBtn.hwnd, PicRc)
   ' Prefix "&" wird in einen Unterstrich gewandelt
   Call DrawTextEx(PicBtn.hdc, sCapt, Len(sCapt), PicRc, DT_NOCLIP _
            Or DT_CENTER Or DT_SINGLELINE Or DT_VCENTER, ByVal 0&)
   
   ' PicBtn-Border zeichnen
   PicBtn.Line (0, 0)-(PicBtn.Width - 1, PicBtn.Height - 1), _
                                         PicBtn.ForeColor, B
   ' PicBtn-Fokus-Rechteck zeichnen
   If FocRect Then
      InflateRect PicRc, -3, -3
      DrawFocusRect PicBtn.hdc, PicRc
   End If
   
End Sub

' Prozedur zu Prfen des MouseIn - MouseOut
Public Sub MouseOverState(ByVal Ctrl As Control)
  
   Dim CurPT As POINTAPI
   Dim TemphWnd As Long
  
   GetCursorPos CurPT

   ' Ermitteln des Handels  unter der Maus:
   TemphWnd = WindowFromPoint(CurPT.x, CurPT.y)
  
   ' Handles vergleichen:
   If Ctrl.hwnd = TemphWnd Then
      ' Feststellen, ob Control gewechselt hat
      If GetCapture() <> TemphWnd Then ' <------- "Mouse-In"
         ' Verfolgung starten
         SetCapture Ctrl.hwnd
      
         ' Farben anpassen
         Call SetPicBtnColors(Ctrl, vbWhite, vbBlack)
    
'      Else                             ' <------- "Mouse-Over"
'         ' Verfolgung fortsetzen
      End If
   Else                                ' <------- "Mouse-Out"
      ' Verfolgung stoppen
      ReleaseCapture
      
      ' Farben anpassen
      Call SetPicBtnColors(Ctrl, Me.BackColor, Me.ForeColor)
 
   End If
End Sub

' Prozedur zum Setzen der PicBox-Buttonfarben
Private Sub SetPicBtnColors(ByVal Ctrl As Control, _
                            ByVal lBackColor As Long, _
                            ByVal lForeColor As Long)
   Ctrl.BackColor = lBackColor
   Ctrl.ForeColor = lForeColor
   If Me.ActiveControl Is cButton(Ctrl.Index) Then
      Call DrawPicButtonCaption(Ctrl, True)  ' mit FokusRect
   Else
      Call DrawPicButtonCaption(Ctrl, False) ' ohne FokusRect
   End If
End Sub



